/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.maybe;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Maybe;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.MaybeEmitter;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.MaybeObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.MaybeOnSubscribe;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Cancellable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.CancellableDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.ExceptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeCreate<T>
extends Maybe<T> {
    final MaybeOnSubscribe<T> source;

    public MaybeCreate(MaybeOnSubscribe<T> source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        Emitter<T> parent = new Emitter<T>(observer);
        observer.onSubscribe(parent);
        try {
            this.source.subscribe(parent);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            parent.onError(ex);
        }
    }

    static final class Emitter<T>
    extends AtomicReference<Disposable>
    implements MaybeEmitter<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        private static final long serialVersionUID = -2467358622224974244L;

        Emitter(MaybeObserver<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSuccess(T value) {
            Disposable d;
            if (this.get() != DisposableHelper.DISPOSED && (d = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
                try {
                    if (value == null) {
                        this.downstream.onError(ExceptionHelper.createNullPointerException("onSuccess called with a null value."));
                    } else {
                        this.downstream.onSuccess(value);
                    }
                }
                finally {
                    if (d != null) {
                        d.dispose();
                    }
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.tryOnError(t)) {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public boolean tryOnError(Throwable t) {
            Disposable d;
            if (t == null) {
                t = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
            }
            if (this.get() != DisposableHelper.DISPOSED && (d = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
                try {
                    this.downstream.onError(t);
                }
                finally {
                    if (d != null) {
                        d.dispose();
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public void onComplete() {
            Disposable d;
            if (this.get() != DisposableHelper.DISPOSED && (d = (Disposable)this.getAndSet(DisposableHelper.DISPOSED)) != DisposableHelper.DISPOSED) {
                try {
                    this.downstream.onComplete();
                }
                finally {
                    if (d != null) {
                        d.dispose();
                    }
                }
            }
        }

        @Override
        public void setDisposable(Disposable d) {
            DisposableHelper.set(this, d);
        }

        @Override
        public void setCancellable(Cancellable c) {
            this.setDisposable(new CancellableDisposable(c));
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public String toString() {
            return String.format("%s{%s}", this.getClass().getSimpleName(), super.toString());
        }
    }
}

